﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private rand As New Random()


    Public Sub New()
        InitializeComponent()
    End Sub


    Private Sub OnTextBlockManipulationStarted(ByVal sender As Object,
                                               ByVal args As ManipulationStartedEventArgs)
        If TypeOf ContentPanel.Background Is SolidColorBrush Then
            TryCast(Application.Current, App).SharedColor =
                (TryCast(ContentPanel.Background, SolidColorBrush)).Color
        End If

        Me.NavigationService.Navigate(New Uri("/SecondPage.xaml", UriKind.Relative))

        args.Complete()
        args.Handled = True
    End Sub


    Protected Overrides Sub OnManipulationStarted(ByVal args As ManipulationStartedEventArgs)
        ContentPanel.Background = New SolidColorBrush(Color.FromArgb(255, CByte(rand.Next(255)),
                                                                          CByte(rand.Next(255)),
                                                                          CByte(rand.Next(255))))

        MyBase.OnManipulationStarted(args)
    End Sub


    Protected Overrides Sub OnNavigatedTo(ByVal args As NavigationEventArgs)
        Dim sharedColor? = (TryCast(Application.Current, App)).SharedColor

        If sharedColor IsNot Nothing Then
            ContentPanel.Background = New SolidColorBrush(sharedColor.Value)
        End If

        MyBase.OnNavigatedTo(args)
    End Sub
End Class
